/*
Copyright © 2005, Apple Computer, Inc.  All rights reserved.
NOTE:  Use of this source code is subject to the terms of the Software
License Agreement for Mac OS X, which accompanies the code.  Your use
of this source code signifies your agreement to such license terms and
conditions.  Except as expressly granted in the Software License Agreement
for Mac OS X, no other copyright, patent, or other intellectual property
license or right is granted, either expressly or by implication, by Apple.
*/

// Todo: make Dictionary Selector parametric based on kDictionaryCount
// Todo: ResizeBox has event handler def in html
// Todo: wrap Dictionary with an object

/*======================================================================
 *	Globals and Global Events
 *======================================================================*/
LOG__("reading script.");

if (!Dictionary) {alert("ERROR: Dictionary Plugin Not Loaded. Dictionary widget will not be functional.");}

var kDictionaryCount = 2;

function setup() {
	DictionarySelector.initLabels();	// now it's ready to use.
	setTimeout('SearchField.adjust();', 0);
	LOG__("load done");
}

if (window.widget) {
	widget.onhide = function () {};
	widget.onremove = function () {Preference.removeInstancePreferences();};
}

window.onfocus = function () {
	LOG__("window.onfocus");
}

window.onblur = function () {
	if ( SearchField.value() == "")	shrink();
	LOG__("window.onblur");
}


/*======================================================================
 *	Window
 *======================================================================*/
// Construct the Dictionary widget window	
var Window = function () {
	LOG__("Window");

	// Dictionary window is created with the shrunk state (defined in Info.plist)
	Window.expanded = false;
	Window.shrunkHeight = window.innerHeight;
	

	// The topbar extender is hidden with the shrunk state
	Window.topbarExtender = document.getElementById("topbarBackgroundExtender");
	Window.topbarExtenderStyle = Window.topbarExtender.style;
	Window.topbarExtenderStyle.height = "0px";

	Window.paper = document.getElementById("paperScroll");
	Window.paperStyle = Window.paper.style;

	Window.initialSize = new Position(381,228);
	
	var x = Preference.get("windowWidth");
	var y = Preference.get("windowHeight");
	if ( x && y)	Window.initialSize = new Position(x,y);

	Window.resizeTo(new Position(381,Window.initialSize.y),false);
	
	var frontWindow = document.getElementById("FrontWindow");
	frontWindow.addEventListener('mousemove', Window.mouseMove, false);
	frontWindow.addEventListener('mouseout', Window.mouseOut, false);
	frontWindow.addEventListener('mousewheel', Window.mousewheel, false);

	// Font size preference: setting the default
	Window.fontSize = Preference.get("fontRelativeSize");
	if ( ! Window.fontSize)	Window.fontSize = 120;
	document.getElementById("DataDiv").style.fontSize = Window.fontSize + "%";
}
window.addEventListener('load', Window, false);

Window.mouseMove = function (event) {
	InfoButton.animator().animateInDirection(1);
}

Window.mouseOut = function (event) {
	InfoButton.animator().animateInDirection(0);
}

Window.mousewheel = function (event) {
	var numClicks = event.wheelDelta / 120;
	Scroller.scrollTo(Scroller.view.topvalue + numClicks * 10, false);
}

Window.currentSize = function () {
	return new Position(window.innerWidth, window.innerHeight);
}

Window.resizeBy = function ( width, height) {
	Window.resizeTo( Window.currentSize().add( new Position( width, height)));
}

Window.resizeTo = function ( newSize, tracking) {
	LOG__("Window.resizeTo:"+newSize);

	// limit the size
	if ( newSize.x < 381)	newSize.x = 381;
	if ( newSize.y < 228)	newSize.y = 228;

	var currentSize = Window.currentSize();
	if ( ! newSize.equal(currentSize) || tracking==false ) {
		Window.expandedHeight = newSize.y;

		if ( Window.expanded) {
			window.resizeTo(newSize.x,newSize.y);
			//document.body.style.height = newSize.y + "px";
		}

		Window.paperStyle.top    = (Window.expanded ? 0 : -(newSize.y-37)) + "px";
		Window.paperStyle.height = (newSize.y-37) + "px";

		var diff = newSize.sub(currentSize);
		Scroller.windowResized(diff.x, diff.y, tracking);

		if ( ! Window.expanded) {
			window.resizeTo(newSize.x,currentSize.y);
		}

		// set the window size pref
		if ( tracking == false && Window.expanded) {
			Window.initialSize.set(newSize);
			Preference.set("windowWidth",  newSize.x);
			Preference.set("windowHeight", newSize.y);
		}
	}
}

Window.animateExpandWidth = function (width) {
	Window._targetwidth  = width;
	Window._currentwidth = window.innerWidth;
	Window._animateInterval = setInterval("Window.animateExpandWidth_animate();",0);
}

Window.animateExpandWidth_animate = function () {
	var increment = 30;
	if ( Window._currentwidth < Window._targetwidth) {
		Window._currentwidth = min( Window._currentwidth+increment, Window._targetwidth);
		window.resizeTo(Window._currentwidth,window.innerHeight);
	} else {
		clearInterval(Window._animateInterval);
		DictionarySelector.initLabels();
		Window.resizeTo( new Position(Window._targetwidth,window.innerHeight), false);
	}
}

/*======================================================================
 *	ExpandShrink Animation
 *======================================================================*/
function expand (func) { ExpandShrink.animate(1,func);}
function shrink (func) { ExpandShrink.animate(0,func);}

var ExpandShrink = new Object ();

ExpandShrink.animator = function () {
	if ( ! ExpandShrink._animator) {
		var duration = 400;
		ExpandShrink._animator = new Animator (-Window.paper.offsetHeight, 0, duration, ExpandShrink.setValue, ExpandShrink.onStart, ExpandShrink.onFinish);
	}
	return ExpandShrink._animator;
}

ExpandShrink.setValue = function (animator,value) {
	var offsetFromTop = parseInt(value + Window.paper.offsetHeight);
	
	if ( offsetFromTop < 17) {
		ExpandShrink.extenderHeight = offsetFromTop;
		Window.topbarExtenderStyle.height = ExpandShrink.extenderHeight + "px";
	} else if ( ExpandShrink.extenderHeight != 17) {
		ExpandShrink.extenderHeight = 17;
		Window.topbarExtenderStyle.height = ExpandShrink.extenderHeight + "px";
	}
	
	if ( ExpandShrink.expandInWidth ) {
		var width = Window.initialSize.x - ExpandShrink.expandInWidth * (1-animator.currentScale);
		window.resizeTo(width, window.innerHeight);
	}

	Window.paperStyle.top = parseInt(value) + "px";
}

ExpandShrink.onStart = function (animator) {
	if ( animator.isMin() ) {
		window.resizeTo(window.innerWidth, Window.expandedHeight);
	}
}

ExpandShrink.onFinish = function (animator) {
	if ( animator.isMin() ) {
		window.resizeTo(window.innerWidth, Window.shrunkHeight);
	}
	if (ExpandShrink.callback)	setTimeout(ExpandShrink.callback,0);
}

ExpandShrink.animate = function (expand,callback) {
	LOG__("ExpandShrink.animate");
	Window.expanded = expand;	// todo:is this the best way ?

	var animator = ExpandShrink.animator();

	if ( expand != animator.isMax() ) {
		if ( expand && window.innerWidth != Window.initialSize.x) {
			ExpandShrink.expandInWidth = Window.initialSize.x - window.innerWidth;
		} else {
			ExpandShrink.expandInWidth = 0;
		}

		if ( animator.direction )
			animator.fromValue = -Window.paper.offsetHeight;
		else
			animator.toValue = -Window.paper.offsetHeight;
		ExpandShrink.callback = callback;
		animator.animateInDirection(expand);
	}
}

/*======================================================================
 *	Search Field
 *======================================================================*/
var SearchField = function () {
	LOG__("SearchField");
	var element = document.getElementById("SearchField");
	element.onsearch = new Function ("event", "SearchField.onSearch(this);");
	element.onfocus  = new Function ("event", "SearchField.onFocus(this);");
	element.onblur   = new Function ("event", "SearchField.onBlur(this);");
	element.onkeypress   = new Function ("reset", "SearchField.onKeypress(this);");
	SearchField.element = element;
	LOG__("SearchField done");
}
window.addEventListener('load', SearchField, false);

SearchField.adjust   = function () {SearchField.setValue(".");SearchField.focus();SearchField.setValue("");}

SearchField.focus    = function () { SearchField.element.focus();}
SearchField.value    = function () { return SearchField.element.value;}
SearchField.setValue = function (value) { SearchField.element.value = value;}

SearchField.onFocus = function (elem) { SearchField.focused = true; LOG__("SearchField.onfocus");}
SearchField.onBlur = function (elem) { SearchField.focused = false; LOG__("SearchField.onblur");}
SearchField.onKeypress = function ()  { SearchField._keypressed = true;}
SearchField.onSearch = function (elem) {
	View.newSearch( elem.value, SearchField.focused, SearchField._keypressed);
	SearchField._keypressed = false;
}

/*======================================================================
 *	History Button & History management
 *======================================================================*/
var HistoryButtons = new Array (2);

HistoryButton = function (direction) {
	var element = document.getElementById("HistoryButton"+direction);
	this.element = element;
	this.direction = direction;
	this.enabled = false;
	this.element.addEventListener('mousedown', HistoryButton.mouseDown, false);
	this.element.wrapperObject = this;
}

HistoryButton.init = function () {
	HistoryButtons[0] = new HistoryButton (0);
	HistoryButtons[1] = new HistoryButton (1);
}

HistoryButton.mouseDown = function (event) {
	var button = event.toElement.wrapperObject;
	if ( button && button.isEnabled())
		TrackMouse(button);
}

HistoryButton.prototype = {
enable    : function () { this.element.src = this.direction ? "Images/right.png" : "Images/left.png"; this.enabled = true; },
disable   : function () { this.element.src = this.direction ? "Images/right_d.png" : "Images/left_d.png"; this.enabled = false; },
pressed   : function () { this.element.src = this.direction ? "Images/right_p.png" : "Images/left_p.png";},
isEnabled : function () { return this.enabled; },
highlight : function (highlight) { if (highlight) this.pressed(); else this.enable();},
clicked   : function () {
	if ( this.isEnabled() ) {
		var view = this.direction ? History.forward() : History.back();
		LOG__("Getting History:"+view);
		History.lock = true;
		view();
		expand();
		History.lock = false;
	}
}
}	// HistoryButton.prototype


/*
 *	History object
*/
var History = function () {
	History.stack = new Array ();
	History.top = 0;	// index of the last element + 1
	History.sp = 0;	// stack pointer. a new entry will be placed on this index.

	HistoryButton.init();
}
window.addEventListener('load', History, false);


History.add = function (func) {
	if ( History.lock) return;
	if ( History.sp==0 || func.toString() != History.stack[History.sp-1].toString() ) {
		LOG__("History.add");
		History.stack[History.sp++] = func;
	
		for ( var i = History.sp; i < History.top; ++i)
			History.stack[i] = null;
		History.top = History.sp;
	
		HistoryButtons[1].disable();
		if ( History.sp > 1)
			HistoryButtons[0].enable();
	} else {
		LOG__("History.add: same entry");
	}
}
History.back = function () {
	LOG__("History.back:");
	--History.sp;
	
	HistoryButtons[1].enable();
	if ( History.sp == 1)
		HistoryButtons[0].disable();

	return History.stack[History.sp-1];
}
History.forward = function () {
	LOG__("History.forward:");
	HistoryButtons[0].enable();
	if ( History.sp + 1 == History.top)
		HistoryButtons[1].disable();

	if ( History.sp < History.top )
		return History.stack[History.sp++];
	else
		return null;
}

/*======================================================================
 *	Dictionary Selector & Dictionary management
 *======================================================================*/
var DictionarySelector = function () {
	for ( var i=0; i<kDictionaryCount; ++i) {
		DictionarySelector._element[i] = document.getElementById("DictionarySelect"+i);
		DictionarySelector._element[i].onclick = new Function ("event", "DictionarySelector_onClick("+i+");");
		var name = Preference.get('DictionaryName'+i);
		DictionarySelector._dictionaryName[i] = name;
		DictionarySelector._dictionaryObj[i]  = Dictionary.dictionaryForName(name);
		if ( DictionarySelector._dictionaryObj[i] == null) {
			switch (i) {
			case 0: name = "New Oxford American Dictionary"; break;
			case 1: name = "Oxford American Writers Thesaurus"; break;
			}
			DictionarySelector._dictionaryName[i] = name;
			DictionarySelector._dictionaryObj[i]  = Dictionary.dictionaryForName(name);
		}
	}
	LOG__("DictionarySelector done");
}
window.addEventListener('load', DictionarySelector, false);

DictionarySelector.initLabels = function () {
	for ( var dicNo=0; dicNo<kDictionaryCount; ++dicNo) {
		DictionarySelector._updateLabel(dicNo);
	}
	DictionarySelector.setCurrent(0);
}

DictionarySelector._element       = new Array (kDictionaryCount);
DictionarySelector._dictionaryObj = new Array (kDictionaryCount);
DictionarySelector._dictionaryName = new Array (kDictionaryCount);
DictionarySelector.dictionary = function (dicNo) { return DictionarySelector._dictionaryObj[dicNo];}
DictionarySelector.dictionaryName = function (dicNo) { return DictionarySelector._dictionaryName[dicNo];}

DictionarySelector.setDictionary = function (dicNo, newDicObj, setPreference) {
	DictionarySelector._dictionaryObj[dicNo] = newDicObj;
	DictionarySelector._updateLabel(dicNo);
	if ( setPreference) {
		var name = DictionarySelector.dictionaryName(dicNo);
		Preference.set('DictionaryName'+dicNo, name ? name : "-" );
	}
}
DictionarySelector._updateLabel = function (dicNo) {
	// TODO: get dictionary label from the dictionary themselves
	var label;
	var name = DictionarySelector.dictionaryName(dicNo);
	if ( name.indexOf("Dictionary") != -1)	label="Dictionary";
	else if ( name.indexOf("Thesaurus") != -1)	label="Thesaurus";
	else label="";
	DictionarySelector._element[dicNo].innerText = label;
}


DictionarySelector.current = function () { return DictionarySelector._currentDicNo;}
DictionarySelector.setCurrent = function (newDicNo) {
	DictionarySelector._currentDicNo = newDicNo;
	DictionarySelector.redraw();
}
DictionarySelector.redraw = function () {
	for ( var i=0; i<kDictionaryCount; ++i) {
		DictionarySelector._element[i].style.opacity = (i==DictionarySelector._currentDicNo) ? 1.0 : 0.3;
	}
}

function DictionarySelector_onClick(newDicNo) {
	if ( DictionarySelector.current() != newDicNo) {
		DictionarySelector.setCurrent(newDicNo);	// setCurrent will be called by the new view again
		View.getInstance(newDicNo,ViewSelector.current()).showForDictionarySelectorClick();
	}
}


/*======================================================================
 *	View Selector
 *======================================================================*/
var ViewSelector = function () {
	ViewSelector.element = document.getElementById("ViewSelectDiv");
	ViewSelector.element.addEventListener('mousedown', ViewSelector.mouseDown, false);
	ViewSelector._current = 0;
	LOG__("ViewSelector done");
}
window.addEventListener('load', ViewSelector, false);

ViewSelector.mouseDown = function (event) {
	TrackMouse(ViewSelector);
}

ViewSelector.highlight = function (highlight) {
	var state = highlight ^ ViewSelector.current();
	ViewSelector._highlight(state);
}

ViewSelector.clicked = function () {
	var newViewKind = (ViewSelector.current() == 0) ? 1 : 0;
	ViewSelector.setCurrent(newViewKind);
	View.getInstance(DictionarySelector.current(),newViewKind).showForViewSelectorClick();
}

ViewSelector.updateLabelChar = function (term) {
	if ( ! ViewSelector.labelElement)
		ViewSelector.labelElement = document.getElementById("IndexCharDiv");
	ViewSelector.labelElement.innerText = term.charAt(0).toUpperCase();
}

ViewSelector.current = function () {
	return ViewSelector._current;
}

ViewSelector.setCurrent = function ( viewNo) {
	if ( ViewSelector._current != viewNo ) {
		ViewSelector._current = viewNo;
		ViewSelector._highlight( viewNo);
	}
}

ViewSelector._highlight = function (highlight) {
	if ( highlight != ViewSelector._isHighlighted ) {
		ViewSelector._isHighlighted = highlight;
		if ( ! ViewSelector.imageElement)
			ViewSelector.imageElement = document.getElementById("ViewSelectImg");
		ViewSelector.imageElement.src = highlight ? "Images/thumb pressed.png" : "Images/thumb.png";
	}
}

/*======================================================================
 *	Scroller
 *======================================================================*/
var Scroller = function () {
	LOG__("Scroller");
	Scroller.scroller = document.getElementById("scroller");
	Scroller.scrollerStyle = Scroller.scroller.style;
	Scroller.scrollerTrack = document.getElementById("scrollerTrack");
	Scroller.scrollerTrackMiddleStyle = document.getElementById("scrollerTrackMiddle").style;
	Scroller.scrollerTrackContent = document.getElementById("scrollerTrackContent");
	Scroller.scrollerNob = document.getElementById("scrollerNob");
	Scroller.scrollerNobStyle = Scroller.scrollerNob.style;
	Scroller.scrollerNobMiddleStyle = document.getElementById("scrollerNobMiddle").style;

	Scroller.scrollerNob.addEventListener('mousedown', Scroller.nobMouseDown, false);
	Scroller.scrollerTrackContent.addEventListener('mousedown', Scroller.trackMouseDown, false);
	
	Scroller.scrollerStyle.visibility = "hidden";
}
window.addEventListener('load', Scroller, false);


Scroller.setView = function (view) {
	LOG__("Scroller.setView");
	Scroller.view = view;
	Scroller.windowResized();
}

Scroller.windowResized = function (widthChanged, heightChanged, tracking) {
	if ( !Scroller.view)	{return;}
	LOG__("Scroller.windowResized: "+widthChanged+", "+heightChanged);

	Scroller._windowResized();

	// update content
	var view = Scroller.view;
	if ( view.windowResized)	view.windowResized(widthChanged, heightChanged, tracking);
	if ( view.scrolled)			view.scrolled(tracking);
}
Scroller._windowResized = function () {
	LOG__("Scroller._windowResized");
	var view = Scroller.view;
	view.topvalue = view.style.top ? parseInt(view.style.top) : 0;

	// Update the track
	var trackImageLength = Scroller.scroller.offsetHeight;
	Scroller.scrollerTrackMiddleStyle.height = (trackImageLength-36) + "px";	// top and bottom cap = 10px
	Scroller.trackContentLength = Scroller.scrollerTrackContent.offsetHeight;

	// Update the nob length
	Scroller.setNobLen( view.parentElement.clientHeight / view.element.offsetHeight);

	// Update the scroll limit
	var mintop = min(view.parentElement.clientHeight - view.element.offsetHeight,0);
	Scroller.mintop = mintop;

	// Adjust the scroll position if necessary
	Scroller._scrollTo(view.topvalue);
}

Scroller.scrollTo = function (scrolltop,tracking) {
	LOG__("Scroller.scrollTo");
	Scroller._scrollTo(scrolltop);
	var view = Scroller.view;
	if ( view.scrolled)		view.scrolled(tracking);
}
Scroller._scrollTo = function (scrolltop) {
	LOG__("Scroller._scrollTo:"+scrolltop);
	var view = Scroller.view;
	if ( scrolltop < Scroller.mintop)	scrolltop = Scroller.mintop;
	if ( scrolltop > 0 )				scrolltop = 0;
	view.topvalue = scrolltop;
	view.style.top = scrolltop + "px";
	Scroller.setNob( scrolltop);
}

Scroller.setNob = function (scrolltop) {
	var topvalue = Scroller.getNobTopFromScrollTop(scrolltop);
	Scroller.scrollerNobStyle.top = topvalue + "px";
	Scroller.nobtopvalue = topvalue;
}
Scroller.getNobTopFromScrollTop = function (scrolltop) {
	// 0 <= scrolltop <= Scroller.mintop
	// 0 <= nobtop    <= Scroller.trackContentLength-scrollerNob.offsetHeight
	return (Scroller.trackContentLength-Scroller.scrollerNob.offsetHeight) * scrolltop/Scroller.mintop;
}
Scroller.getScrollTopFromNobTop = function (nobtop) {
	return nobtop * Scroller.mintop / (Scroller.trackContentLength-Scroller.scrollerNob.offsetHeight);
}
Scroller.setNobLen = function (value) {
	if ( value >= 1) {
		Scroller.scrollerStyle.visibility = "hidden";
	} else {
		var adjust = 10;
		Scroller.scrollerStyle.visibility = "visible";
		var middleLen = (Scroller.trackContentLength-adjust) * value + adjust -18;	// top and bottom cap = 9px
		if ( middleLen < 10)	middleLen = 10;
		Scroller.scrollerNobMiddleStyle.height = middleLen + "px";
	}
}

/*
 *	Scrolling by the nob
*/
Scroller.nobMouseDown = function (event) {
	Scroller.clickOffset = Scroller.nobtopvalue - event.y;
	document.addEventListener("mousemove", Scroller.nobMouseMove, true); 
	document.addEventListener("mouseup", Scroller.nobMouseUp, true); 
	TrackMouse.tracking = true;
}
Scroller.nobMouseMove = function (event) {
	LOG__("Scroller.nobMouseMove");
	var newnobtopvalue = Scroller.clickOffset + event.y;
	Scroller.scrollTo( Scroller.getScrollTopFromNobTop(newnobtopvalue),true);
}
Scroller.nobMouseUp = function (event) { 
	LOG__("Scroller.nobMouseUp");
	TrackMouse.tracking = false;
	document.removeEventListener("mousemove", Scroller.nobMouseMove, true); 
    document.removeEventListener("mouseup", Scroller.nobMouseUp, true);
    Scroller.clickOffset = 0;

	var view = Scroller.view;
	if ( view.windowResized)	view.windowResized(0, 0, false);
}


/*
 *	Scrolling by clicking on the track
*/
Scroller.trackMouseDown = function (event) {
	if ( !Scroller.clickOffset) {
		LOG__("Scroller.trackMouseDown");
		Scroller.mouseY = Scroller.getMouseYOffset(event);
		Scroller.pageScrollDirection = Scroller.getPageScrollDirection(Scroller.mouseY);
		Scroller.trackMouseIn = true;
		Scroller.pageScroll(false);

		Scroller.pageScrollTimer = setInterval("Scroller.pageScroll(true);",150);
	
		Scroller.scrollerTrackContent.addEventListener("mouseover", Scroller.trackMouseOver, false);
		Scroller.scrollerTrackContent.addEventListener("mouseout",  Scroller.trackMouseOut,  false);
		document.addEventListener("mousemove", Scroller.trackMouseMove, true);
		document.addEventListener("mouseup", Scroller.trackMouseUp, true);
		TrackMouse.tracking = true;
	}
}
Scroller.trackMouseMove = function (event) {
	Scroller.mouseY = Scroller.getMouseYOffset(event);
}
Scroller.trackMouseOver = function (event) {
	Scroller.trackMouseIn = true;
}
Scroller.trackMouseOut = function (event) {
	Scroller.trackMouseIn = false;
}
Scroller.trackMouseUp = function (event) {
	TrackMouse.tracking = false;
	clearInterval(Scroller.pageScrollTimer);
	Scroller.scrollerTrackContent.removeEventListener("mousemove", Scroller.trackMouseMove, false);
	Scroller.scrollerTrackContent.removeEventListener("mouseover", Scroller.trackMouseOver, false);
	Scroller.scrollerTrackContent.removeEventListener("mouseout",  Scroller.trackMouseOut,  false);
    document.removeEventListener("mouseup", Scroller.trackMouseUp, true); 

	var view = Scroller.view;
	if ( view.windowResized)	view.windowResized(0, 0, false);
}
Scroller.getMouseYOffset = function (event) {
	var mouseY = event.offsetY + ((event.toElement.id == "scrollerTrackContent") ? 0 : event.toElement.offsetTop+event.toElement.parentNode.offsetTop);
	return mouseY;
}
Scroller.getPageScrollDirection = function (mouseY) {
	var nobbot = Scroller.nobtopvalue + Scroller.scrollerNob.offsetHeight;
	var dir = (mouseY < Scroller.nobtopvalue) ? 1 : ((mouseY < nobbot) ? 0 : -1);
	return dir;
}
Scroller.pageScroll = function (tracking) {
	if ( Scroller.trackMouseIn) {
		var newDir = Scroller.getPageScrollDirection(Scroller.mouseY);
		if ( newDir == Scroller.pageScrollDirection) {
			var view = Scroller.view;
			var pageheight = view.parentElement.clientHeight - 20;
			Scroller.scrollTo(view.topvalue + Scroller.pageScrollDirection * pageheight, tracking);
		}
	}
}

/*======================================================================
 *	Resize Box
 *======================================================================*/
var ResizeBox = new Object ();

ResizeBox.mouseDown = function (event) {
	ResizeBox.clickOffset = Window.currentSize().sub(event);
	document.addEventListener("mousemove", ResizeBox.mouseMove, true); 
	document.addEventListener("mouseup", ResizeBox.mouseUp, true); 
	TrackMouse.tracking = true;
}
ResizeBox.mouseMove = function (event) {
	Window.resizeTo(ResizeBox.clickOffset.add(event),true); 
}
ResizeBox.mouseUp = function (event) { 
	TrackMouse.tracking = false;
	Window.resizeTo(ResizeBox.clickOffset.add(event), false); 
    document.removeEventListener("mousemove", ResizeBox.mouseMove, true); 
    document.removeEventListener("mouseup", ResizeBox.mouseUp, true); 
}


/*======================================================================
 *	Info Button
 *======================================================================*/
var InfoButton = Object ();

InfoButton.init = function () {
	var flip = document.getElementById ('flip');
	var fliprollie = document.getElementById('fliprollie');
	InfoButton.flip = flip;
	InfoButton.fliprollie = fliprollie;
	InfoButton.style = flip.style;
	flip.addEventListener('click', InfoButton.click, false);
	flip.addEventListener('mouseover', InfoButton.mouseOver, false);
	flip.addEventListener('mouseout', InfoButton.mouseOut, false);
}

InfoButton.animator = function () {
	if ( ! InfoButton._animator) {
		InfoButton.init();
		InfoButton._animator = new Animator (0, 0.6, 500, InfoButton.setValue);
	}
	return InfoButton._animator;
}

InfoButton.setValue = function (animator, value) {
	InfoButton.style.opacity = value;
}

InfoButton.click = function (event) {
	showbackside(event);
}

InfoButton.mouseOver = function (event) {
	InfoButton.fliprollie.style.display = 'block';
}

InfoButton.mouseOut = function (event) {
	InfoButton.fliprollie.style.display = 'none';
}


/*======================================================================
 *	The back side
 *======================================================================*/
var Backside = function () {
	var doneDiv = document.getElementById('done');
	createGenericButton( doneDiv, getLocalizedString('Done'), selectDone);
}
window.addEventListener('load', Backside, false);


function showbackside(event) {
	LOG__("showbackside");
	var front = document.getElementById("FrontWindow");
	var back = document.getElementById("BackWindow");

	if (window.widget)
		widget.prepareForTransition("ToBack");

	PopulateBacksideUI();

	front.style.display="none";
	back.style.display="block";

	var offset = (window.innerWidth-381)/2;
	back.style.left = offset;
	widget.setCloseBoxOffset(offset+15, 5);
	
	if (window.widget)
		setTimeout ('widget.performTransition();', 0);

	InfoButton.fliprollie.style.display = 'none';
}

function selectDone () {
	LOG__("selectDone");
	var front = document.getElementById("FrontWindow");
	var back = document.getElementById("BackWindow");
	
	if (window.widget)
		widget.prepareForTransition("ToFront");

	back.style.display="none";
	front.style.display="block";

	widget.setCloseBoxOffset(15, 5);

	View.handleStyleUpdate();
	setTimeout("DictionarySelector.redraw();",0);

	if (window.widget)
		setTimeout ('widget.performTransition();', 0);
}

var kFontSize    = [100, 120, 144, 100];

function PopulateBacksideUI () {
	// Font size preference: constructing the UI when the back side is opened for the first time
	var select = document.getElementById("FontSizeSelect");
	if ( ! select.firstChild ) {
		var element = document.createElement("option");
		element.innerText = getLocalizedString("Small");
		select.appendChild(element);
	
		element = document.createElement("option");
		element.innerText = getLocalizedString("Medium");
		select.appendChild(element);
	
		element = document.createElement("option");
		element.innerText = getLocalizedString("Large");
		select.appendChild(element);
		
		switch (Window.fontSize) {
		case kFontSize[0]:	select.selectedIndex = 0; break;
		case kFontSize[1]:	select.selectedIndex = 1; break;
		case kFontSize[2]:	select.selectedIndex = 2; break;
		default:
			element = document.createElement("option");
			element.innerText = Window.fontSize + "%";
			select.appendChild(element);
			select.selectedIndex = 3;
			kFontSize[3] = Window.fontSize;
		}
	
		var fontSizeLabel = document.getElementById("FontSizeLabel");
		fontSizeLabel.innerText = getLocalizedString("Font size:");
	}
}

// Font size preference: a new size was selected
function FontSizeChanged(select) {
	var newSize = kFontSize[select.selectedIndex];
	if ( newSize != Window.fontSize ) {
		Window.fontSize = newSize;
		Preference.set("fontRelativeSize", Window.fontSize);
		var datadiv = document.getElementById("DataDiv");
		datadiv.style.fontSize = Window.fontSize + "%";
		
	}
}

/*======================================================================
 *	View management
 *======================================================================*/
var View = new Object ();

View.setCurrent = function (newView) {
	LOG__("View.setCurrent");
	if ( View._current != newView) {
		if ( View._current)	View._current.hide();
		DictionarySelector.setCurrent(newView.idNo);
		ViewSelector.setCurrent(newView.viewKind);
		newView.style.visibility = "visible";
		View._current = newView;
	}
	Scroller.setView(newView);
	setTimeout(View.focus,0);
}

View.focus = function () {
	if ( ! SearchField.focused) {
		SearchField.element.focus();
		SearchField.element.select();
	}
}

View.getCurrent = function () {
	if ( typeof View._current == 'undefined')	View._current = null;
	return View._current;
}

View.getInstance = function (dicNo,viewNo) {
	return viewNo ? IndexView.getInstance(dicNo) : DefinitionView.getInstance(dicNo);
}

View.newSearch = function (string, focused, keypressed) {
	LOG__("View.newSearch");
	View._string = string;
	View._focused = focused;

	if ( string.length == 0 ) {
		if ( Window.expanded)
			View.clear(!keypressed);
	} else {
		if ( Window.expanded) {
			View._newSearch();
		} else {
			if ( !(focused && keypressed)) {
				expand(View._newSearch);
			}
		}
	}
}

View._newSearch = function ()
{
	LOG__("View._newSearch:"+View._string);
	View._prepareForSearch();

	if ( View._focused ) {
		var view = View.getCurrent();
		if ( !view)	view = View.getInstance(DictionarySelector.current(),0);
		view.showForNewSearch(View._string);
	} else {
		View.getInstance(DictionarySelector.current(),0).showForNewSearch(View._string);
	}
}

View._prepareForSearch = function () {
	DefinitionView.resetForNewSearch();
	IndexView.resetForNewSearch();
}

View.clear = function (doshrink) {
	LOG__("View.clear doshrink="+doshrink);
	View._prepareForSearch();

	View.getCurrent().clear();
	if (doshrink && Window.expanded)	shrink();
}

View.handleStyleUpdate = function () {
	var view = View.getCurrent();
	if ( view && view.viewKind == 1 && view.entries && view.entries.length > 0) {
			view.updateWithEntries(view.entries);
	}
	Scroller.windowResized();
}


/*======================================================================
 *	Definition View
 *======================================================================*/
var SHOWMISSPELLEDWORDS = false;

DefinitionView = function (id) {
	var parentElement = document.getElementById('DefinitionViewDiv');
	var element = document.createElement("div");
	element.setAttribute("id","DefinitionView"+id);
	element.setAttribute("class","DefinitionView");
	parentElement.appendChild(element);

	this.idNo = id;
	this.element = element;
	this.parentElement = parentElement;
	this.style = element.style;
}

DefinitionView._instances  = new Array(kDictionaryCount);
DefinitionView.getInstance = function (id) {
	var instance = DefinitionView._instances[id];
	if ( ! instance)
		instance = DefinitionView._instances[id] = new DefinitionView (id);
	return instance;
}

DefinitionView.resetForNewSearch = function () {
	// nop
}

DefinitionView.prototype = {
viewKind: 0,

show : function () {
	LOG__("DefinitionView:show");
	View.setCurrent(this);
},

hide : function () {
	this.style.visibility = "hidden";
},


showForNewSearch : function (string) {
	LOG__("showForNewSearch:"+string);
	this.style.top = "0px";
	this.updateWithString(string,'BGWT');
	this.show();
},

showForDictionarySelectorClick : function () {
	if ( typeof (DefinitionView._currentEntryKey) == "undefined" ) {
		DefinitionView._currentEntryKey = "";
	}
	LOG__("showForDictionarySelectorClick:currentKey:"+DefinitionView._currentEntryKey);
	this.updateWithString(DefinitionView._currentEntryKey,'=   ');
	this.show();
},

showForViewSelectorClick : function () {
	var indexview = View.getInstance(this.idNo,1);
	var entry = indexview.clickedEntry;
	if ( ! entry && indexview.entries )	entry = indexview.entries.entryAtIndex(0);
	
	if ( entry)
		this.updateWithEntries(entry);
	this.show();
},

showWithHistory : function (string,uid) {
	this.updateWithString(string,'=   ',uid);
	SearchField.setValue(string);
	this.show();
},

updateWithString : function (string, method, uid) {
	LOG__("updateWithString:"+string);
	var keymethod = string+"/"+method+"/"+uid;
	if ( this.searchKeyMethod != keymethod) {
		if ( string == "") {
			this.updateWithError(string);
		} else {
			var entries = Dictionary.findWords( DictionarySelector.dictionary(this.idNo), string.toLowerCase(), method, 100, 0);
			if ( ! entries || entries.length == 0) {
				this.updateWithError(string);
			} else {
				if ( typeof (uid) == "undefined") {
					this.updateWithEntries(entries);
				} else {
					for ( var i=0; i<entries.length; ++i) {
						if ( uid == Word.uniqueID(entries[i])) {
							this.updateWithEntries(entries[i]);
							break;
						}
					}
				}
			}
		}
		DefinitionView._currentEntryKey = string;
		this.searchKeyMethod = keymethod;
	}
},

// This is the bottoleneck routine
updateWithEntries : function (entries) {
	this.style.top = "0px";
	this.searchKeyMethod = "";
	var html = "";
	if ( typeof (entries) == "function") {
		SearchField.setValue(Word.key(entries));
		html += Word.data(entries).replace(/<\?xml [^>]+>/, "");
		this.element.innerHTML = html;
		DefinitionView._currentEntryKey = Word.key(entries);
		History.add( new Function ( "", 'DefinitionView.getInstance('+this.idNo+').showWithHistory("'+Word.key(entries)+'",'+Word.uniqueID(entries)+');' ) );
	} else {
		if ( entries) {
			for ( var i=0; i<entries.length; ++i) {
				if (html.length)
					html += "<hr/>";
				html += Word.data(entries[i]).replace(/<\?xml [^>]+>/, "");
			}
		}
		this.element.innerHTML = html;
		DefinitionView._currentEntryKey = Word.key(entries[0]);
		History.add( new Function ( "", 'DefinitionView.getInstance('+this.idNo+').showWithHistory("'+Word.key(entries[0])+'");' ) );
	}
	ViewSelector.updateLabelChar(DefinitionView._currentEntryKey);
},

updateWithError : function (string) {
	this.element.innerHTML = "";
	if ( string != "") {
		var guessedWords;
		if ( SHOWMISSPELLEDWORDS && (guessedWords = Dictionary.guessesForWord(string)) && guessedWords.length > 0) {
			var misspelledDiv = document.createElement("div");
			misspelledDiv.setAttribute('id', "misspelledDiv");
			misspelledDiv.innerText = "Alternative spelling:";
			for ( var i=0; i<guessedWords.length; ++i) {
				var div = document.createElement("div");
				div.innerText = guessedWords[i];
				// this needs to be an exact match. may be existence of the word needs to be checked beforehand
				div.onclick = new Function('View.getInstance('+this.idNo+',0).showForNewSearch("' +guessedWords[i]+ '")');
				misspelledDiv.appendChild(div);
			}
			this.element.appendChild(misspelledDiv);
		} else if ( string.length > 0 ) {
			var messageDiv = document.createElement("div");
			messageDiv.setAttribute('id', "messageDiv");
			messageDiv.innerText = getLocalizedString('"%@" could not be found.').replace("%@",string);
			this.element.appendChild(messageDiv);
		}
	}
	ViewSelector.updateLabelChar(string);
},

clear : function () {
	this.element.innerHTML = "";
	this.searchKeyMethod = "";
	ViewSelector.updateLabelChar("");
	this.show();
}

}	// DefinitionView.prototype

/*======================================================================
 *	Index View
 *======================================================================*/
IndexView = function (id) {
	LOG__("Creating IndexView");
	var parentElement = document.getElementById('IndexViewDiv');
	this.parentElement = parentElement;

	var element = document.createElement("div");
	element.setAttribute("id","IndexView"+id);
	element.setAttribute("class","IndexView");
	parentElement.appendChild(element);
	this.element = element;

	var canvas = document.createElement('canvas');
	canvas.setAttribute('width', element.parentNode.offsetWidth);
	canvas.setAttribute('height', element.parentNode.offsetHeight);
	canvas.setAttribute('class', 'Canvas');
	element.appendChild(canvas);
	this.canvas = canvas;
	
	var box = document.createElement('div');
	element.appendChild(box);
	this.contentbox = box;

	var table = document.createElement("table");
	table.setAttribute('class', "IndexTable");
	table.addEventListener("mousedown", IndexView.showDefinitionAtTableIndex, false);
	table.addEventListener('mouseover', IndexView.highlight, false);
	table.addEventListener('mouseout',  IndexView.highlightClear, false);
	this.contentbox.appendChild(table);
	this.table = table;

	this.idNo = id;
	this.style = element.style;
}
IndexView.tableOffsetTop = 17;

IndexView._instances  = new Array(kDictionaryCount);
IndexView.getInstance = function (id) {
	var instance = IndexView._instances[id];
	if ( ! instance)
		instance = IndexView._instances[id] = new IndexView (id);
	return instance;
}

IndexView.resetForNewSearch = function () {
	for ( var i=0; i<kDictionaryCount; ++i) {
		if ( typeof IndexView._instances[i] != "undefined")
			IndexView._instances[i].entries = null;
	}
}

IndexView.prototype = {
viewKind: 1,

show : function () {
	LOG__("IndexView:show");
	View.setCurrent(this);
},

hide : function () {
	this.style.visibility = "hidden";
},


// new search
showForNewSearch : function (string) {
	LOG__("IndexView:showForNewSearch");
	this.clear();
	this.updateWithString(string,-1);
	this.show();
},

// Dictionary selector click
showForDictionarySelectorClick : function () {
	this.showForViewSelectorClick();
},

// View selector click
showForViewSelectorClick : function () {
	LOG__("IndexView:showForViewSelectorClick");
	var string = SearchField.value();
	// if entries are already loaded just show it.
	if ( this.entries && string == this.entries.string) {
		this.show();
	} else {
		this.showForNewSearch(string);
	}
},

// Back / Forth bottuns
showWithHistory : function (string,highlight,top) {
	LOG__("IndexView:showWithHistory:"+string+","+highlight+","+top);
	SearchField.setValue(string);
	this.updateWithString(string,highlight);
	if ( !top)	top = 0;
	this.style.top = top + "px";
	this.show();
	this.highlight(highlight);
},

updateWithString : function (string, highlight) {
	var needUpdate = ( !this.entries || string != this.entries.string);
	LOG__("IndexView:updateWithString");
	if ( needUpdate) {
		this.entries = new Lookup(DictionarySelector.dictionary(this.idNo), string, 'bgwt');
		LOG__("Lookup done. "+this.entries.length+" entries found");

		this.clear();

		if ( this.entries && this.entries.length > 0) {
			this.updateWithEntries(this.entries);
			History.add( new Function ( "", "IndexView.getInstance("+this.idNo+').showWithHistory("'+this.entries.string+'",'+this.entries.highlight+");" ) );
			//this.highlight(highlight);
		} else {
			this.updateWithError(string);
		}
	} else {
		//this.highlight(highlight);
	}
},

updateWithEntries : function (entries) {
	LOG__("updateWithEntries");

	this.updateTableRowHight();
	var maxIndex = entries.length;
	this.contentbox.style.height = (IndexView.tableRowHight*maxIndex+IndexView.tableOffsetTop) + "px";
	this.element.style.height = (IndexView.tableRowHight*maxIndex+IndexView.tableOffsetTop) + "px";
	// we are drawing at the view.scrolled handler

	ViewSelector.updateLabelChar(entries.string);
},

showDefinitionAtIndex : function (index) {
	LOG__("showDefinitionAtIndex:"+index);
	this.entries.highlight = index;
	this.clickedEntry = this.entries.entryAtIndex(index);
	History.add( new Function ( "", "IndexView.getInstance("+this.idNo+").showWithHistory('"+this.entries.string+"',"+index+","+parseInt(this.style.top)+");" ) );
	View.getInstance(this.idNo,0).showForViewSelectorClick();
},

highlight : function (index) {
	if ( index >= 0) {
		var nodeNo = index - this.minNodeNo;
		var node = this.table.childNodes[nodeNo].firstChild.firstChild.firstChild.firstChild;
		this.highlightNode(node,index);
	}
},

updateWithError : function (string) {
	LOG__("IndexView.updateWithError:"+string);
	if ( string != "") {
		var messageDiv = document.createElement("div");
		messageDiv.setAttribute('id', "messageDiv");
		messageDiv.style.marginLeft = "7px";
		messageDiv.innerText = getLocalizedString('"%@" could not be found.').replace("%@",string);
		this.element.appendChild(messageDiv);
		this.messageDiv = messageDiv;
	}
	ViewSelector.updateLabelChar(string);
},

clear : function () {
	LOG__("clearing the index view"+this.idNo);
	if ( this.messageDiv)		{this.element.removeChild(this.messageDiv); this.messageDiv = null;}
	var table = this.table;
	while (table.firstChild)	{table.removeChild(table.firstChild);}
	this.contentbox.style.height = "0px";
	this.style.height = "0px";
	this.style.top = "0px";
	table.style.marginTop = "0px";
	this.minNodeNo = 0;
	this.maxNodeNo = 0;
	this.highlightClearNode();
	this.show();
},

windowResized : function (widthChanged, heightChanged, tracking) {
	LOG__("indexview.windowResized: "+widthChanged+", "+heightChanged+", "+tracking);

	if ( widthChanged || typeof widthChanged == 'undefined' || tracking == false) {
		IndexView.maxDefinitionColumnLength = 0;
		var trs = this.table.childNodes;
		var nodeNo = this.minNodeNo;
		for ( var i = 0; i < trs.length; ++i, ++nodeNo) {
			//this.truncateHeadword(trs[i],nodeNo);
			this.truncateDefinition(trs[i],nodeNo,tracking);
		}
	}

	this.canvas.setAttribute('width', this.element.parentNode.offsetWidth);
	this.canvas.setAttribute('height', this.element.parentNode.offsetHeight+20);
},

updateTableRowHight : function () {
	if ( typeof IndexView.fontSize == 'undefined' || IndexView.fontSize != Window.fontSize) {
		IndexView.fontSize = Window.fontSize;
		var trs = this.table.childNodes;
		if ( trs.length > 0) {
			IndexView.tableRowHight = this.table.offsetHeight / trs.length;
		} else {
			var testdata = "<tr><td><div class='IndexTerm'>x</div></td><td><span class='IndexDef'>x</span></td></tr>"
			this.table.innerHTML = testdata;
			IndexView.tableRowHight = this.table.offsetHeight;
			this.table.removeChild(this.table.firstChild);
		}
	}
},

headwordColumnWidth : function (update) {
	return 100;
},

scrolled : function (tracking) {
	LOG__("indexview.scrolled");
	
	if ( this.entries) {
		this.updateTableRowHight();
		var offsettop = IndexView.tableOffsetTop;
		var rowheight = IndexView.tableRowHight;
	
		var scrollAmountInRow = (-this.topvalue - offsettop)/rowheight;
		var screenHeightInRow = this.parentElement.offsetHeight/rowheight;
	
		var minNodeNo = max(parseInt(scrollAmountInRow), 0);
		var maxNodeNo = min(parseInt(scrollAmountInRow+screenHeightInRow)+1, this.entries.length);
	
		var table = this.table;
		if ( maxNodeNo < this.maxNodeNo) {
			var removeCount = this.maxNodeNo - max(maxNodeNo,this.minNodeNo);
			for ( var i=0; i<removeCount; ++i) {
				table.removeChild(table.lastChild);
			}
		} else if ( maxNodeNo > this.maxNodeNo) {
			for ( var nodeNo=max(minNodeNo,this.maxNodeNo); nodeNo<maxNodeNo; ++nodeNo) {
				var tr = this.rowHTML(nodeNo);
				table.appendChild(tr);
				this.truncateHeadword(tr,nodeNo);
				this.truncateDefinition(tr,nodeNo,tracking);
			}
		}
		if ( minNodeNo > this.minNodeNo) {
			var removeCount = min(minNodeNo,this.maxNodeNo) - this.minNodeNo;
			for ( var i=0; i<removeCount; ++i) {
				table.removeChild(table.firstChild);
			}
		} else if ( minNodeNo < this.minNodeNo ) {
			for ( var nodeNo=min(maxNodeNo,this.minNodeNo)-1; nodeNo>=minNodeNo; --nodeNo) {
				var tr = this.rowHTML(nodeNo);
				table.insertBefore(tr, table.firstChild);
				this.truncateHeadword(tr,nodeNo);
				this.truncateDefinition(tr,nodeNo,tracking);
			}
		}
		this.minNodeNo = minNodeNo;
		this.maxNodeNo = maxNodeNo;
	
		// set table position
		var height = this.element.offsetHeight;
		var top = minNodeNo * rowheight + offsettop;
		table.style.marginTop = top + "px";
		this.element.style.height = height + "px";
	
		// adjust the canvas to it
		this.canvas.style.top = top + "px";
	}
},

rowHTML : function (nodeNo) {
	var tr = document.createElement("tr");
	tr.setAttribute("id","i"+this.idNo+"_"+nodeNo);
	var headword = this.entries.headwordAtIndex(nodeNo);
	var width = this.headwordColumnWidth(false);
	tr.innerHTML = "<td width='"+width+"px'><div class='IndexTerm'><div>"+headword+"</div></div></td><td><div><span class='IndexDef'></span></div></td>";
	return tr;
},

truncateHeadword : function (tr,nodeNo) {
	var headworddiv = tr.firstChild.firstChild.firstChild;
	if ( headworddiv.scrollWidth > headworddiv.offsetWidth || headworddiv.truncated) {
		TruncateString(headworddiv, this.entries.headwordAtIndex(nodeNo), headworddiv.offsetWidth+2);
	}
},

truncateDefinition : function (tr,nodeNo,tracking) {
	if ( tracking) {
		tr.childNodes[1].firstChild.firstChild.innerText = this.entries.defstringAtIndex(nodeNo);
	} else {
		TruncateString(tr.childNodes[1].firstChild.firstChild, this.entries.defstringAtIndex(nodeNo), this.getMaxDefinitionColumnLength());
	}
},

getMaxDefinitionColumnLength : function () {
	if ( IndexView.maxDefinitionColumnLength == 0) {
		IndexView.maxDefinitionColumnLength = this.table.firstChild.childNodes[1].offsetWidth - 10;
	}
	return IndexView.maxDefinitionColumnLength;
},

highlightNode : function ( node, index) {
	//LOG__("highlightNode:"+node);
	this.highlightClearNode();

	var headworddiv = node.parentNode;
	if ( headworddiv.scrollWidth > headworddiv.offsetWidth || headworddiv.truncated) {
		headworddiv.innerText = this.entries.headwordAtIndex(index);
		node = headworddiv.firstChild;
		var extend = headworddiv.scrollWidth - headworddiv.offsetWidth;
		var headworddivstyle = headworddiv.style;
		var defdiv = headworddiv.parentNode.parentNode.parentNode.childNodes[1].firstChild;
		headworddivstyle.position = "absolute";
		headworddivstyle.top = headworddiv.offsetTop + "px";
		headworddivstyle.left = headworddiv.offsetLeft + "px";
		defdiv.firstChild.style.marginLeft = (defdiv.firstChild.offsetLeft-extend) + "px";
		defdiv.style.marginLeft = extend + "px";
		defdiv.style.overflow = "hidden";

		this._headwordScrolling = true;
	}

	this._highlightNode = node;
	this._highlightRect = drawHighlight( node, this.canvas);
},

highlightClearNode : function () {
	//LOG__("highlightClearNode");
	if ( this._highlightRect) {
		drawHighlight.clear(this._highlightRect, this.canvas);

		if ( this._headwordScrolling ) {
			var headworddiv = this._highlightNode.parentNode;
			var tr = headworddiv.parentNode.parentNode.parentNode;
			var defdiv = tr.childNodes[1].firstChild;
			var index = tr.sectionRowIndex +  this.minNodeNo;
			headworddiv.style.position = "static";
			defdiv.firstChild.style.marginLeft = "0px";
			defdiv.style.marginLeft = "4px";
			this.truncateHeadword(tr,index);
			this._headwordScrolling = null;
		}
	
		this._highlightRect = null;
		this._highlightNode = null;
	}
}
} //IndexView.prototype

IndexView.maxDefinitionColumnLength = 0;

IndexView.showDefinitionAtTableIndex = function (event) {
	var view = View.getCurrent();
	var node;
	for ( node=event.toElement; node.nodeType!=1 || node.nodeName!="TR"; node=node.parentNode) {}
	var index = node.sectionRowIndex + view.minNodeNo;
	view.highlightClearNode();
	view.showDefinitionAtIndex(index);
}


IndexView.highlight = function (event) {
	if ( TrackMouse.tracking)	return;

	//LOG__("IndexView.highlight");
	// look for the headword
	var view = View.getCurrent();
	var node = event.toElement;
	if ( node.tagName != "TABLE") {
		var previousNode = node;
		for ( var i=0; i<4 && node && node.tagName != "TR"; ++i, previousNode=node, node=node.parentNode)
			{}
		if ( node && node.tagName == "TR" && previousNode == node.firstChild) {
			var headwordTextNode = node.firstChild.firstChild.firstChild.firstChild;
			if ( headwordTextNode != view._highlightNode) {
				var index = node.sectionRowIndex + view.minNodeNo;
				view.highlightNode(headwordTextNode,index);
			}
		}
	}
}

IndexView.highlightClear = function (event) {
	if ( TrackMouse.tracking)	return;

	//LOG__("IndexView.highlightClear");
	// is the new location still on the table ?
	var view = View.getCurrent();
	var node = event.toElement;
	for ( var i=0; i<4 && node && node.tagName != "TR"; ++i, node=node.parentNode)
		{}
	if ( node && node.tagName == 'TR') {
		var headwordTextNode = node.firstChild.firstChild.firstChild.firstChild;
		if ( headwordTextNode != view._highlightNode) {
			view.highlightClearNode();
		}
	} else {
			view.highlightClearNode();
	}
}


/*======================================================================
 *======================================================================*/
/*======================================================================
 *	Lookup object
 *    also manages some other properties (e.g. highlight) that IndexView 
 *    needs to maintain with this object
 *======================================================================*/
var Lookup = function (dicNo, key, method) {
	this.dicNo = dicNo;
	this.string = key;
	this.method = method;
	this.length = 0;
	this._entries = Dictionary.findWords( dicNo, key.toLowerCase(), method, 100000, 0);
	if ( this._entries) {
		this.length = this._entries.length;
	}
	this.headword  = new Array(this.length);
	this.defstring = new Array(this.length);

	this.highlight = 0;
}

Lookup.prototype = {
entryAtIndex : function (index) {
	if ( this._entries == null || index < 0 || index >= this._maxIndex)
		return null;
	return this._entries[index];
},

headwordAtIndex : function (index) {
	if ( typeof this.headword[index] == 'undefined')
		this.headword[index] = Word.headword(this._entries[index]);
	return this.headword[index];
},

defstringAtIndex : function (index) {
	if ( typeof this.defstring[index] == 'undefined') {
		this.defstring[index] = Word.string(this._entries[index]);
	}

	if ( typeof this.defstring[index] == 'undefined') {
		//alert(this.headword[index]+":"+Word.data(this._entries[index]));
	}
	
	return this.defstring[index];
}
}

/*======================================================================
 *	Preference & Localization Utilities
 *======================================================================*/
var Preference = new Object();
Preference.instancePrefs = new Array();

Preference.get = function (key) {
	if (window.widget) {
		var str = widget.preferenceForKey(_createkey(key));
		if ( str == null) {
			str = widget.preferenceForKey(key);
			if ( str == null) {
				str = localizedStrings[key];
			}
		}
		return str;
	}
}

Preference.set = function (key,value) {
	if (window.widget) {
		var instanceKey = _createkey(key);
		widget.setPreferenceForKey( value,  instanceKey);
		widget.setPreferenceForKey( value,  key);
		Preference.instancePrefs[instanceKey] = true;
	}
}

Preference.removeInstancePreferences = function () {
	if (window.widget) {
		for ( key in Preference.instancePrefs ) {
			widget.setPreferenceForKey(null, key);
		}
	}
}

function _createkey(key) {
        return widget.identifier + "-" + key;
}

function getLocalizedString(key) {
	if ( typeof localizedStrings[key] != 'undefined') {
		return localizedStrings[key];
	}
	return key;
}

/*======================================================================
 *	UTILITIES
 *======================================================================*/
function max(a,b) { return (a>b) ? a : b; }
function min(a,b) { return (a<b) ? a : b; }
function abs(a)   { return (a>0) ? a : -a; }
function interpolate(from, to, ease) {
    return from + (to - from) * ease;
}

/*======================================================================
 *	Position object
 *======================================================================*/
var Position = function (x,y) { this.x = x; this.y = y;}
Position.prototype = {
set : function (pos) { this.x = pos.x; this.y = pos.y;},
add : function (pos) { return new Position(this.x+pos.x, this.y+pos.y);},
sub : function (pos) { return new Position(this.x-pos.x, this.y-pos.y);},
equal : function (pos) { return (this.x==pos.x) && (this.y==pos.y); },
toString : function () { return "["+this.x+","+this.y+"]";}
}

/*======================================================================
 *	Tracking Mouse
 *======================================================================*/
TrackMouse = function (view) {
	if ( ! TrackMouse.tracking) {
		TrackMouse.tracking = true;
		view.highlight(true);
		TrackMouse.element = view.element;
		TrackMouse.view    = view;
		TrackMouse.mouseWithin = true;

		TrackMouse.element.addEventListener("mouseover", TrackMouse.mouseOver, true);
		TrackMouse.element.addEventListener("mouseout",  TrackMouse.mouseOut,  true);
		document.addEventListener("mouseup",  TrackMouse.mouseUp,   true);
	}
}

TrackMouse.mouseOver = function (event) {
	LOG__("TrackMouse.mouseOver");
	TrackMouse.mouseWithin = true;
	TrackMouse.view.highlight(true);
}

TrackMouse.mouseOut = function (event) {
	LOG__("TrackMouse.mouseOut");
	TrackMouse.mouseWithin = false;
	TrackMouse.view.highlight(false);
}

TrackMouse.mouseUp = function (event) {
	TrackMouse.tracking = false;
	TrackMouse.element.removeEventListener("mouseover", TrackMouse.mouseOver, true);
	TrackMouse.element.removeEventListener("mouseout",  TrackMouse.mouseOut,  true);
	document.removeEventListener("mouseup",  TrackMouse.mouseUp,   true);
	TrackMouse.view.highlight(false);
	if ( TrackMouse.mouseWithin)
		TrackMouse.view.clicked();
}

/*======================================================================
 *	Drawing Highlight on text
 *======================================================================*/
function drawHighlight(elem, canvas)
{
	//LOG__("drawHighlight:"+elem+","+canvas);
	var radius = drawHighlight.radius;

	var x = elem.offsetLeft;
	var y = elem.offsetTop;
	var count = 0;
	for ( var parent = elem.offsetParent; parent != canvas.parentNode; parent = parent.offsetParent) {
		x += parent.offsetLeft;
		y += parent.offsetTop;
		if ( parent.tagName == "BODY")	return;
	}
	var height = elem.offsetHeight;
	var width = elem.offsetWidth > elem.parentNode.offsetWidth ? elem.parentNode.offsetWidth : elem.offsetWidth;

	x -= canvas.offsetLeft;
	y -= canvas.offsetTop;

	var context = canvas.getContext("2d");
	context.save();
	context.fillStyle = "rgba(0,0,0,0.2)"
	context.arc( x,		 y+radius,			radius, Math.PI*3/2,	Math.PI,	1);
	context.arc( x,		 y+height-radius,	radius, Math.PI,	Math.PI/2,	1);
	context.arc( x+width, y+height-radius,	radius, Math.PI/2, 0,	1);
	context.arc( x+width, y+radius,			radius, 0,	Math.PI*3/2,	1);
	context.fill();
	context.restore();
	
	return {x:x, y:y, width:width, height:height};
}
drawHighlight.radius = 7;

drawHighlight.clear = function (rect, canvas) {
	var radius = drawHighlight.radius;
	var context = canvas.getContext("2d");
	context.clearRect(rect.x-radius, rect.y, rect.width+radius*2, rect.height);
}


/*======================================================================
 *	Truncate strings
 *======================================================================*/
// there should be a better way...
TruncateString = function (element, string, maxVisibleLen) {
	//LOG__("TruncateString:"+element+", "+element.scrollWidth+":"+maxVisibleLen+", "+string);
	element.innerText = string;
	element.truncated = false;
	if ( element.scrollWidth > maxVisibleLen) {
		element.truncated = true;
		element.innerText = string.substring(0,TruncateString.maxLength) + "…";
		if ( element.scrollWidth <= maxVisibleLen) {
			for ( var len = TruncateString.maxLength; len < string.length; ++len) {
				element.innerText = string.substring(0,len) + "…";
				if (element.scrollWidth > maxVisibleLen) {
					truncatedString = string.substring(0,len-1) + "…";
					element.innerText = truncatedString;
					TruncateString.maxLength = len;
					//alert("TruncateString:maxLength to "+len);
					return;
				}
			}
		}
		for ( var len = TruncateString.maxLength; len > 0; --len) {
				element.innerText = string.substring(0,len) + "…";
				if ( element.scrollWidth <= maxVisibleLen) {
						break;
				}
		}
	}
}
TruncateString.maxLength = 31;

/*======================================================================
 *	Animator
 *======================================================================*/
Animator = function (from,to,duration,setvalue,onstart,onfinish) {
	this.fromValue = from;
	this.toValue  = to;
	this.duration = duration;
	this.setvalue = setvalue;
	this.onstart  = onstart;
	this.onfinish = onfinish;

	this.currentValue = this.fromValue;
	this.direction    = this.toValue > this.fromValue;
	this.startTime = 0;
	this.framerate = 13;
	this.timer = null;
}

Animator.prototype = {

animate : function () {
	if ( !this.timer) {
		this.startTime = (new Date).getTime() - this.framerate;
		var self = this;
		this.timer = setInterval( function () {self._frame();}, this.framerate);
		if (this.onstart)
			self.onstart(this);
	}
},

animateInDirection : function (direction) {
	this.setDirection(direction);
	if ( this.currentValue != this.toValue)
		this.animate();
},

stopAnimate : function () {
	if (this.timer) {
		clearInterval(this.timer);
		this.timer = null;
	}
},

setState : function (scale) {
	this.stopAnimate();
	
	this.currentScale = scale;
	this.currentValue = interpolate(this.fromValue, this.toValue, scale);
	this.setvalue(this,this.currentValue);

	if ( scale == 1) {
		var self = this;
		setTimeout(function () {self.onfinish(self);}, 0);	// call after the last frame is drawn
	}
},

_frame : function () {
	//LOG__("_frame");
	var T = (new Date).getTime() - this.startTime;

	if ( T >= this.duration) {
		this.stopAnimate();

		this.currentScale = 1;
		this.currentValue = this.toValue;
		this.setvalue(this,this.currentValue);

		if (this.onfinish) {
			var self = this;
			setTimeout( function () {self.onfinish(self);}, 0);	// call after the last frame is drawn
		}
	} else {
		var scale = 0.5 - (0.5 * Math.cos(Math.PI * max( T, 0) / this.duration));
		this.currentScale = scale;
		this.currentValue = interpolate(this.fromValue, this.toValue, scale);
		this.setvalue(this,this.currentValue);
	}
},

setDirection : function (direction) {
	if ( direction != this.direction) {
		this.direction = direction;

		var temp = this.fromValue;
		this.fromValue = this.toValue;
		this.toValue = temp;
	
		if (this.timer) {
			var now = (new Date).getTime();
			var remainingTime = this.startTime + this.duration - now;
			this.startTime = now - remainingTime;
		}
	}
},

isMin : function () {
	return this.direction ? this.currentValue == this.fromValue : this.currentValue == this.toValue;
},

isMax : function () {
	return this.direction ? this.currentValue == this.toValue : this.currentValue == this.fromValue;
}

}


/*======================================================================
 *	Debugging
 *======================================================================*/
function LOG__(arg) {
	//alert(timer.reset()+":"+arg);
}

/*======================================================================
 *	End of the script
 *======================================================================*/
